/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabFactions;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabQuests;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Locale;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IRegistryDelegate;
import noppes.npcs.CommonProxy;
import noppes.npcs.CreativeTabNpcs;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelPartData;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.PacketHandlerPlayer;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.IMinecraft;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.ClientEvent;
import noppes.npcs.api.handler.data.IKeySetting;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.mixin.client.gui.recipebook.IRecipeListMixin;
import noppes.npcs.api.mixin.client.network.INetworkPlayerInfoMixin;
import noppes.npcs.api.mixin.client.particle.IParticleFlameMixin;
import noppes.npcs.api.mixin.client.particle.IParticleManagerMixin;
import noppes.npcs.api.mixin.client.particle.IParticleSmokeNormalMixin;
import noppes.npcs.api.wrapper.WrapperMinecraft;
import noppes.npcs.blocks.CustomBlock;
import noppes.npcs.blocks.CustomBlockPortal;
import noppes.npcs.blocks.CustomBlockSlab;
import noppes.npcs.blocks.CustomBlockStairs;
import noppes.npcs.blocks.CustomChest;
import noppes.npcs.blocks.CustomDoor;
import noppes.npcs.blocks.CustomLiquid;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.PacketHandlerClient;
import noppes.npcs.client.VersionChecker;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.PresetController;
import noppes.npcs.client.fx.EntityEnderFX;
import noppes.npcs.client.gui.GuiBlockBuilder;
import noppes.npcs.client.gui.GuiBlockCopy;
import noppes.npcs.client.gui.GuiBorderBlock;
import noppes.npcs.client.gui.GuiBoundarySetting;
import noppes.npcs.client.gui.GuiBuilderSetting;
import noppes.npcs.client.gui.GuiMerchantAdd;
import noppes.npcs.client.gui.GuiNbtBook;
import noppes.npcs.client.gui.GuiNpcDimension;
import noppes.npcs.client.gui.GuiNpcMobSpawner;
import noppes.npcs.client.gui.GuiNpcMobSpawnerMounter;
import noppes.npcs.client.gui.GuiNpcPather;
import noppes.npcs.client.gui.GuiNpcRedstoneBlock;
import noppes.npcs.client.gui.GuiNpcRemoteEditor;
import noppes.npcs.client.gui.GuiNpcWaypoint;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityItemStacks;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.dimentions.GuiCreateDimension;
import noppes.npcs.client.gui.global.GuiNPCManageBanks;
import noppes.npcs.client.gui.global.GuiNPCManageDialogs;
import noppes.npcs.client.gui.global.GuiNPCManageFactions;
import noppes.npcs.client.gui.global.GuiNPCManageLinkedNpc;
import noppes.npcs.client.gui.global.GuiNPCManageMail;
import noppes.npcs.client.gui.global.GuiNPCManageMarkets;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiNPCManageRecipes;
import noppes.npcs.client.gui.global.GuiNPCManageTransporters;
import noppes.npcs.client.gui.global.GuiNpcQuestReward;
import noppes.npcs.client.gui.global.SubGuiNPCManageDeal;
import noppes.npcs.client.gui.mainmenu.GuiDropEdit;
import noppes.npcs.client.gui.mainmenu.GuiNPCGlobalMainMenu;
import noppes.npcs.client.gui.mainmenu.GuiNPCInv;
import noppes.npcs.client.gui.mainmenu.GuiNpcAI;
import noppes.npcs.client.gui.mainmenu.GuiNpcAdvanced;
import noppes.npcs.client.gui.mainmenu.GuiNpcDisplay;
import noppes.npcs.client.gui.mainmenu.GuiNpcStats;
import noppes.npcs.client.gui.model.GuiCreationParts;
import noppes.npcs.client.gui.player.GuiCustomChest;
import noppes.npcs.client.gui.player.GuiCustomContainer;
import noppes.npcs.client.gui.player.GuiLog;
import noppes.npcs.client.gui.player.GuiMailbox;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.player.GuiNPCBankChest;
import noppes.npcs.client.gui.player.GuiNPCDeadInventory;
import noppes.npcs.client.gui.player.GuiNPCTrader;
import noppes.npcs.client.gui.player.GuiNpcCarpentryBench;
import noppes.npcs.client.gui.player.GuiNpcFollower;
import noppes.npcs.client.gui.player.GuiNpcFollowerHire;
import noppes.npcs.client.gui.player.GuiNpcQuestRewardItem;
import noppes.npcs.client.gui.player.GuiTransportSelection;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionInv;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionTalents;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeItem;
import noppes.npcs.client.gui.roles.GuiNpcBankSetup;
import noppes.npcs.client.gui.roles.GuiNpcFollowerSetup;
import noppes.npcs.client.gui.roles.GuiNpcItemGiver;
import noppes.npcs.client.gui.roles.GuiNpcTransporter;
import noppes.npcs.client.gui.script.GuiScript;
import noppes.npcs.client.gui.script.GuiScriptBlock;
import noppes.npcs.client.gui.script.GuiScriptDoor;
import noppes.npcs.client.gui.script.GuiScriptGlobal;
import noppes.npcs.client.gui.script.GuiScriptItem;
import noppes.npcs.client.gui.select.GuiTextureSelection;
import noppes.npcs.client.model.ModelBipedAlt;
import noppes.npcs.client.model.ModelNPCGolem;
import noppes.npcs.client.model.ModelNpcAlt;
import noppes.npcs.client.model.ModelNpcCrystal;
import noppes.npcs.client.model.ModelNpcDragon;
import noppes.npcs.client.model.ModelNpcSlime;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.client.renderer.ModelBuffer;
import noppes.npcs.client.renderer.RenderCustomNpc;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.client.renderer.RenderNPCPony;
import noppes.npcs.client.renderer.RenderNpcCrystal;
import noppes.npcs.client.renderer.RenderNpcDragon;
import noppes.npcs.client.renderer.RenderNpcSlime;
import noppes.npcs.client.renderer.RenderProjectile;
import noppes.npcs.client.renderer.blocks.TileEntityCustomBannerRenderer;
import noppes.npcs.client.renderer.blocks.TileEntityItemStackCustomRenderer;
import noppes.npcs.client.util.aw.ArmourersWorkshopUtil;
import noppes.npcs.config.TrueTypeFont;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.containers.ContainerAvailabilityInv;
import noppes.npcs.containers.ContainerBuilderSettings;
import noppes.npcs.containers.ContainerCarpentryBench;
import noppes.npcs.containers.ContainerChestCustom;
import noppes.npcs.containers.ContainerCustomChest;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.containers.ContainerDead;
import noppes.npcs.containers.ContainerLayer;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.containers.ContainerNPCCompanion;
import noppes.npcs.containers.ContainerNPCDropSetup;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.containers.ContainerNPCFollowerSetup;
import noppes.npcs.containers.ContainerNPCInv;
import noppes.npcs.containers.ContainerNPCTrader;
import noppes.npcs.containers.ContainerNPCTraderSetup;
import noppes.npcs.containers.ContainerNPCTransportSetup;
import noppes.npcs.containers.ContainerNpcItemGiver;
import noppes.npcs.containers.ContainerNpcQuestReward;
import noppes.npcs.containers.ContainerNpcQuestRewardItem;
import noppes.npcs.containers.ContainerNpcQuestTypeItem;
import noppes.npcs.controllers.KeyController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcAlex;
import noppes.npcs.entity.EntityNpcClassicPlayer;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.items.CustomArmor;
import noppes.npcs.items.CustomBow;
import noppes.npcs.items.CustomFishingRod;
import noppes.npcs.items.CustomFood;
import noppes.npcs.items.CustomShield;
import noppes.npcs.items.CustomTool;
import noppes.npcs.items.CustomWeapon;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.particles.CustomParticle;
import noppes.npcs.particles.CustomParticleSettings;
import noppes.npcs.reflection.client.ItemModelMesherForgeReflection;
import noppes.npcs.reflection.client.renderer.texture.TextureManagerReflection;
import noppes.npcs.reflection.client.renderer.tileentity.TileEntityItemStackRendererReflection;
import noppes.npcs.reflection.client.resources.LocaleReflection;
import noppes.npcs.reflection.client.settings.KeyBindingReflection;
import noppes.npcs.util.TempFile;
import noppes.npcs.util.Util;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding QuestLog = new KeyBinding("key.quest.log", 38, "key.categories.gameplay");
    public static KeyBinding Scene1;
    public static KeyBinding Scene2;
    public static KeyBinding Scene3;
    public static KeyBinding SceneReset;
    public static FontContainer Font;
    public static PlayerData playerData;
    public static final Map<String, TempFile> loadFiles;
    public static Map<Integer, List<UUID>> notVisibleNPC;
    public static Map<String, Map<String, TreeMap<ResourceLocation, Long>>> texturesData;
    private static final Map<Integer, KeyBinding> keyBindingMap;
    private static final List<ResourceLocation> notLoadTextures;
    public static IMinecraft mcWrapper;

    public static void bindTexture(ResourceLocation location) {
        try {
            if (location == null) {
                return;
            }
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            ITextureObject ob = manager.func_110581_b(location);
            if (ob == null && !notLoadTextures.contains(location)) {
                ob = new SimpleTexture(location);
                manager.func_110579_a(location, ob);
                notLoadTextures.add(location);
            }
            if (ob != null) {
                GlStateManager.func_179144_i((int)ob.func_110552_b());
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public static void checkLocalization() {
        File langDir = new File(CustomNpcs.Dir, "assets/customnpcs/lang");
        if (!langDir.exists() || !langDir.isDirectory()) {
            return;
        }
        LogWriter.info("Check Mod Localization");
        try {
            Class<?> i18n = Class.forName("net.minecraft.client.resources.I18n");
            Map<String, String> properties = null;
            for (Field field : i18n.getDeclaredFields()) {
                if (field.getType() != Locale.class) continue;
                field.setAccessible(true);
                properties = LocaleReflection.getProperties((Locale)field.get(null));
                break;
            }
            if (properties == null) {
                return;
            }
            LogWriter.debug("Localization properties found. Size: " + properties.size());
            String currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            for (int i = 0; i < (currentLanguage.equals("en_us") ? 1 : 2); ++i) {
                File lang = new File(langDir, (i == 0 ? "en_us" : currentLanguage) + ".lang");
                if (!lang.exists() || !lang.isFile()) continue;
                try {
                    String line;
                    BufferedReader reader = Files.newBufferedReader(lang.toPath());
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#") || !line.contains("=")) continue;
                        String[] vk = line.split("=");
                        properties.put(vk[0], vk[1]);
                    }
                    reader.close();
                    continue;
                }
                catch (Exception e) {
                    LogWriter.error("Error load custom localization", e);
                }
            }
        }
        catch (Exception e) {
            LogWriter.error("Error localization class found: ", e);
        }
    }

    private static BufferedImage colorTexture(BufferedImage buffer, Color color, boolean onlyGray) {
        if (buffer == null || color == null) {
            return buffer;
        }
        for (int v = 0; v < buffer.getHeight(); ++v) {
            for (int u = 0; u < buffer.getWidth(); ++u) {
                String b;
                String g;
                String r;
                int c = buffer.getRGB(u, v);
                int al = c >> 24 & 0xFF;
                if (al == 0) continue;
                if (onlyGray) {
                    Color k = new Color(c);
                    if (k.getRed() != 127 || k.getGreen() != 127 || k.getBlue() != 127) continue;
                    buffer.setRGB(u, v, color.getRGB());
                    continue;
                }
                int r0 = c >> 16 & 0xFF;
                int g0 = c >> 8 & 0xFF;
                int b0 = c & 0xFF;
                String a = Integer.toHexString(Math.min(al + color.getAlpha(), 255));
                if (a.length() == 1) {
                    a = "0" + a;
                }
                if ((r = Integer.toHexString((r0 + color.getRed()) / 2)).length() == 1) {
                    r = "0" + r;
                }
                if ((g = Integer.toHexString((g0 + color.getGreen()) / 2)).length() == 1) {
                    g = "0" + g;
                }
                if ((b = Integer.toHexString((b0 + color.getBlue()) / 2)).length() == 1) {
                    b = "0" + b;
                }
                buffer.setRGB(u, v, (int)Long.parseLong(a + r + g + b, 16));
            }
        }
        return buffer;
    }

    private static BufferedImage combineTextures(BufferedImage buffer_0, BufferedImage buffer_1) {
        if (buffer_0 == null) {
            return buffer_1;
        }
        if (buffer_1 == null) {
            return buffer_0;
        }
        int w0 = buffer_0.getWidth();
        int w1 = buffer_1.getWidth();
        int h0 = buffer_0.getHeight();
        int h1 = buffer_1.getHeight();
        int w = Math.max(w0, w1);
        int h = Math.max(h0, h1);
        float sw0 = (float)w0 / (float)w;
        float sh0 = (float)h0 / (float)h;
        float sw1 = (float)w1 / (float)w;
        float sh1 = (float)h1 / (float)h;
        BufferedImage total = new BufferedImage(w, h, 6);
        for (int v = 0; v < h; ++v) {
            for (int u = 0; u < w; ++u) {
                String b;
                String g;
                String r;
                int c1;
                int a1;
                int c0 = buffer_0.getRGB((int)((float)u * sw0), (int)((float)v * sh0));
                int a0 = c0 >> 24 & 0xFF;
                if (a0 != 0) {
                    total.setRGB(u, v, c0);
                }
                if ((a1 = (c1 = buffer_1.getRGB((int)((float)u * sw1), (int)((float)v * sh1))) >> 24 & 0xFF) == 0) continue;
                if (a1 == 255) {
                    total.setRGB(u, v, c1);
                    continue;
                }
                int r0 = c0 >> 16 & 0xFF;
                int g0 = c0 >> 8 & 0xFF;
                int b0 = c0 & 0xFF;
                int r1 = c1 >> 16 & 0xFF;
                int g1 = c1 >> 8 & 0xFF;
                int b1 = c1 & 0xFF;
                String a = Integer.toHexString(Math.min(a0 + a1, 255));
                if (a.length() == 1) {
                    a = "0" + a;
                }
                if ((r = Integer.toHexString((r0 + r1) / 2)).length() == 1) {
                    r = "0" + r;
                }
                if ((g = Integer.toHexString((g0 + g1) / 2)).length() == 1) {
                    g = "0" + g;
                }
                if ((b = Integer.toHexString((b0 + b1) / 2)).length() == 1) {
                    b = "0" + b;
                }
                total.setRGB(u, v, (int)Long.parseLong(a + r + g + b, 16));
            }
        }
        return total;
    }

    private static ResourceLocation createPlayerSkin(ResourceLocation skin) {
        if (!skin.func_110624_b().equals("customnpcs") || !skin.func_110623_a().toLowerCase().contains("textures/entity/custom/female_") && !skin.func_110623_a().toLowerCase().contains("textures/entity/custom/male_")) {
            return skin;
        }
        String locSkin = String.format("%s/%s/%s", "assets", skin.func_110624_b(), skin.func_110623_a());
        File file = new File(CustomNpcs.Dir, locSkin);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return skin;
        }
        TextureManager re = Minecraft.func_71410_x().func_110434_K();
        if (file.exists() && file.isFile()) {
            Map<ResourceLocation, ITextureObject> mapTextureObjects = TextureManagerReflection.getMapTextureObjects(re);
            if (!mapTextureObjects.containsKey(skin)) {
                try {
                    BufferedImage skinImage = ImageIO.read(file);
                    SimpleTexture texture = new SimpleTexture(skin);
                    TextureUtil.func_110989_a((int)texture.func_110552_b(), (BufferedImage)skinImage, (boolean)false, (boolean)false);
                    mapTextureObjects.put(skin, (ITextureObject)texture);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
            return skin;
        }
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        String[] path = skin.func_110623_a().replace(".png", "").split("_");
        String gender = "male";
        BufferedImage bodyImage = null;
        BufferedImage hairImage = null;
        BufferedImage faseImage = null;
        BufferedImage legsImage = null;
        BufferedImage jacketsImage = null;
        BufferedImage shoesImage = null;
        ArrayList<BufferedImage> listBuffers = new ArrayList<BufferedImage>();
        Map<ResourceLocation, ITextureObject> mapTextureObjects = TextureManagerReflection.getMapTextureObjects(re);
        block40: for (int i = 0; i < path.length; ++i) {
            int id = -1;
            try {
                id = Integer.parseInt(path[i]);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            switch (i) {
                case 0: {
                    if (!path[i].toLowerCase().endsWith("female")) continue block40;
                    gender = "female";
                    continue block40;
                }
                case 1: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/torsos/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (!mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/torsos/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        bodyImage = TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 2: {
                    try {
                        int c = Integer.parseInt(path[i]);
                        if (c == 0) continue block40;
                        bodyImage = ClientProxy.colorTexture(bodyImage, new Color(c), false);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 3: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/hairs/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (id > 0 && !mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/hairs/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        hairImage = TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 4: {
                    try {
                        int c = Integer.parseInt(path[i]);
                        if (c == 0) continue block40;
                        hairImage = ClientProxy.colorTexture(hairImage, new Color(c), false);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 5: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/faces/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (id > -1 && !mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/faces/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        faseImage = TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 6: {
                    try {
                        int c = Integer.parseInt(path[i]);
                        if (c == 0) continue block40;
                        faseImage = ClientProxy.colorTexture(faseImage, new Color(c), true);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 7: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/legs/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (id > 0 && !mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/legs/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        legsImage = TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 8: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/jackets/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (id > 0 && !mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/jackets/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        jacketsImage = TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                case 9: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/shoes/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (id > 0 && !mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/shoes/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        shoesImage = TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b());
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
                default: {
                    ResourceLocation loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/peculiarities/" + path[i] + ".png");
                    re.func_110577_a(loc);
                    if (id > 0 && !mapTextureObjects.containsKey(loc)) {
                        loc = new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/peculiarities/0.png");
                        re.func_110577_a(loc);
                    }
                    try {
                        listBuffers.add(TextureUtil.func_177053_a((InputStream)rm.func_110536_a(loc).func_110527_b()));
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    continue block40;
                }
            }
        }
        BufferedImage skinImage = null;
        try {
            skinImage = ClientProxy.combineTextures(bodyImage, TextureUtil.func_177053_a((InputStream)rm.func_110536_a(new ResourceLocation("customnpcs", "textures/entity/custom/" + gender + "/torsos/-1.png")).func_110527_b()));
            if (!listBuffers.isEmpty()) {
                for (BufferedImage buffer : listBuffers) {
                    skinImage = ClientProxy.combineTextures(skinImage, buffer);
                }
            }
            skinImage = ClientProxy.combineTextures(skinImage, faseImage);
            skinImage = ClientProxy.combineTextures(skinImage, legsImage);
            skinImage = ClientProxy.combineTextures(skinImage, shoesImage);
            skinImage = ClientProxy.combineTextures(skinImage, jacketsImage);
            skinImage = ClientProxy.combineTextures(skinImage, faseImage);
            skinImage = ClientProxy.combineTextures(skinImage, hairImage);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        try {
            if (skinImage != null) {
                ImageIO.write(skinImage, "PNG", file);
                re.func_110577_a(skin);
                LogWriter.debug("Create new player skin: " + file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        SimpleTexture texture = new SimpleTexture(skin);
        if (skinImage != null) {
            TextureUtil.func_110989_a((int)texture.func_110552_b(), (BufferedImage)skinImage, (boolean)false, (boolean)false);
        }
        mapTextureObjects.put(skin, (ITextureObject)texture);
        return skin;
    }

    public static void pressed(int keyCode) {
        for (int id : keyBindingMap.keySet()) {
            KeyBinding kb = keyBindingMap.get(id);
            if (!kb.isActiveAndMatches(keyCode)) continue;
            NoppesUtilPlayer.sendData(EnumPlayerPacket.KeyActive, id);
        }
    }

    public static void resetSkin(UUID uuid) {
        PlayerSkinController pData = PlayerSkinController.getInstance();
        if (uuid == null || !pData.playerTextures.containsKey(uuid) || !pData.playerNames.containsKey(uuid)) {
            return;
        }
        NetworkPlayerInfo npi = Objects.requireNonNull(Minecraft.func_71410_x().func_147114_u()).func_175102_a(uuid);
        Map<MinecraftProfileTexture.Type, ResourceLocation> map = PlayerSkinController.getInstance().playerTextures.get(uuid);
        Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures = ((INetworkPlayerInfoMixin)npi).npcs$getPlayerTextures();
        playerTextures.clear();
        block4: for (MinecraftProfileTexture.Type epst : map.keySet()) {
            ResourceLocation loc = ClientProxy.createPlayerSkin(map.get(epst));
            LogWriter.debug("Set skin type: " + epst + " = \"" + loc + "\"");
            switch (epst) {
                case CAPE: {
                    playerTextures.put(MinecraftProfileTexture.Type.CAPE, loc);
                    continue block4;
                }
                case ELYTRA: {
                    playerTextures.put(MinecraftProfileTexture.Type.ELYTRA, loc);
                    continue block4;
                }
            }
            playerTextures.put(MinecraftProfileTexture.Type.SKIN, loc);
            TextureManager re = Minecraft.func_71410_x().func_110434_K();
            ResourceLocation locDynamic = new ResourceLocation("minecraft", "dynamic/skin_" + pData.playerNames.get(uuid));
            ResourceLocation locSkins = new ResourceLocation("minecraft", "skins/" + pData.playerNames.get(uuid));
            ITextureObject texture = re.func_110581_b(loc);
            Map<ResourceLocation, ITextureObject> mapTextureObjects = TextureManagerReflection.getMapTextureObjects(re);
            mapTextureObjects.put(locDynamic, texture);
            mapTextureObjects.put(locSkins, texture);
        }
        if (!playerTextures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            playerTextures.put(MinecraftProfileTexture.Type.SKIN, DefaultPlayerSkin.func_177334_a((UUID)npi.func_178845_a().getId()));
        }
        LogWriter.debug("Set skins to player UUID: " + uuid);
    }

    public static void sendSkin(UUID uuid) {
        NetworkPlayerInfo npi = Objects.requireNonNull(Minecraft.func_71410_x().func_147114_u()).func_175102_a(uuid);
        NBTTagCompound nbtPlayer = new NBTTagCompound();
        nbtPlayer.func_186854_a("UUID", uuid);
        NBTTagList listTxrs = new NBTTagList();
        for (MinecraftProfileTexture.Type t : MinecraftProfileTexture.Type.values()) {
            ResourceLocation loc;
            switch (t) {
                case CAPE: {
                    loc = npi.func_178861_h();
                    break;
                }
                case ELYTRA: {
                    loc = npi.func_187106_i();
                    break;
                }
                default: {
                    loc = npi.func_178837_g();
                }
            }
            if (loc == null) continue;
            NBTTagCompound nbtSkin = new NBTTagCompound();
            nbtSkin.func_74778_a("Type", t.name());
            nbtSkin.func_74778_a("Location", loc.toString());
            listTxrs.func_74742_a((NBTBase)nbtSkin);
        }
        nbtPlayer.func_74782_a("Textures", (NBTBase)listTxrs);
        NoppesUtilPlayer.sendData(EnumPlayerPacket.PlayerSkinSet, nbtPlayer);
    }

    @Override
    public void checkBlockFiles(ICustomElement customblock) {
        block98: {
            File texturesDir;
            String n;
            super.checkBlockFiles(customblock);
            String name = customblock.getCustomName().toLowerCase();
            String fileName = Objects.requireNonNull(((Block)customblock).getRegistryName()).func_110623_a().toLowerCase();
            String string = name.equals("blockexample") ? "Example Custom Block" : (name.equals("liquidexample") ? "Example Custom Fluid" : (name.equals("stairsexample") ? "Example Custom Stairs" : (name.equals("slabexample") ? "Example Custom Slab" : (name.equals("facingblockexample") ? "Example Custom Facing Block" : (name.equals("portalexample") ? "Example Custom Portal Block" : (name.equals("chestexample") ? "Example Custom Chest" : (name.equals("containerexample") ? "Example Custom Container" : (n = name.equals("doorexample") ? "Example Custom Door" : name))))))));
            while (n.indexOf(95) != -1) {
                n = n.replace('_', ' ');
            }
            this.setLocalization("tile." + fileName + ".name", n);
            if (customblock instanceof CustomChest) {
                boolean type = ((CustomChest)customblock).isChest;
                String string2 = n = name.contains("example") ? "example" : name;
                if (!n.isEmpty()) {
                    n = ("" + n.charAt(0)).toUpperCase() + n.substring(1);
                }
                while (n.indexOf(95) != -1) {
                    n = n.replace('_', ' ');
                }
                this.setLocalization("custom.chest." + name, "Custom " + (type ? "Chest" : "Container") + ": " + n);
            }
            if (customblock instanceof CustomLiquid) {
                this.setLocalization("fluid." + fileName, n);
            }
            if (!(texturesDir = new File(CustomNpcs.Dir, "assets/customnpcs/textures/" + (customblock instanceof CustomLiquid ? "fluids" : (customblock instanceof CustomBlockPortal ? "environment" : "blocks")))).exists() && !texturesDir.mkdirs()) {
                return;
            }
            File texture = new File(texturesDir, name + ".png");
            if (!texture.exists()) {
                BufferedImage bi;
                InputStream bb = Util.instance.getModInputStream("base_block.png");
                try {
                    bi = ImageIO.read(bb);
                }
                catch (Exception e) {
                    bi = new BufferedImage(16, 16, 6);
                }
                boolean bo = true;
                try {
                    if (customblock instanceof CustomBlock && ((CustomBlock)customblock).hasProperty()) {
                        if (((CustomBlock)customblock).BO != null) {
                            texture = new File(texturesDir, name + "_true.png");
                            if (!texture.exists()) {
                                bo = ImageIO.write(this.getBufferImageOffset(bi, -1, 0.25f, 0, 0, 0, 255), "png", texture);
                            }
                            if (!(texture = new File(texturesDir, name + "_true.png")).exists()) {
                                bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.75f, 0, 0, 0, 255), "png", texture) && bo;
                            }
                        } else if (((CustomBlock)customblock).INT != null) {
                            NBTTagCompound data = ((CustomBlock)customblock).nbtData.func_74775_l("Property");
                            for (int i = data.func_74762_e("Min"); i <= data.func_74762_e("Max"); ++i) {
                                texture = new File(texturesDir, name + "_" + i + ".png");
                                if (texture.exists()) continue;
                                bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.15f + (float)i / 100.0f, 0, 0, 0, 255), "png", texture) && bo;
                            }
                        } else if (((CustomBlock)customblock).FACING != null) {
                            texture = new File(texturesDir, name + "_bottom.png");
                            if (!texture.exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("bp_bottom.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 20, 40, 255), "png", texture);
                            }
                            if (!(texture = new File(texturesDir, name + "_top.png")).exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("bp_top.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 20, 40, 255), "png", texture) && bo;
                            }
                            if (!(texture = new File(texturesDir, name + "_front.png")).exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("bp_front.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 20, 40, 255), "png", texture) && bo;
                            }
                            if (!(texture = new File(texturesDir, name + "_right.png")).exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("bp_right.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 20, 40, 255), "png", texture) && bo;
                            }
                            if (!(texture = new File(texturesDir, name + "_back.png")).exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("bp_back.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 20, 40, 255), "png", texture) && bo;
                            }
                            if (!(texture = new File(texturesDir, name + "_left.png")).exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("bp_left.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 20, 40, 255), "png", texture) && bo;
                            }
                        }
                        if (bo) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" property block");
                        }
                        break block98;
                    }
                    if (customblock instanceof CustomLiquid) {
                        texture = new File(texturesDir, fileName.toLowerCase() + "_still.png.mcmeta");
                        if (!texture.exists()) {
                            bo = Util.instance.saveFile(texture, "{  \"animation\": {\n    \"frametime\": 2\n  }\n}");
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_flow.png.mcmeta")).exists()) {
                            boolean bl = bo = Util.instance.saveFile(texture, "{  \"animation\": {}\n}") && bo;
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_flow.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("wf.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(32, 1024, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 0, 0, 128), "png", texture) && bo;
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_overlay.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("wo.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 0, 0, 128), "png", texture) && bo;
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_still.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("ws.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 512, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, 0, 0, 0, 128), "png", texture) && bo;
                        }
                        if (bo) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" fluid");
                        }
                        break block98;
                    }
                    if (customblock instanceof CustomBlockSlab || customblock instanceof CustomBlockStairs) {
                        boolean isSlab = customblock instanceof CustomBlockSlab;
                        texture = new File(texturesDir, fileName.toLowerCase() + "_top.png");
                        if (!texture.exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("b" + (isSlab ? "l" : "s") + "_top.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, isSlab ? 50 : 0, isSlab ? 80 : 0, 0, 255), "png", texture);
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_bottom.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("b" + (isSlab ? "l" : "s") + "_bottom.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, isSlab ? 50 : 0, isSlab ? 80 : 0, 0, 255), "png", texture) && bo;
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_side.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("b" + (isSlab ? "l" : "s") + "_side.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.5f, isSlab ? 50 : 0, isSlab ? 80 : 0, 0, 255), "png", texture) && bo;
                        }
                        if (bo) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" " + (isSlab ? "slab" : "stairs") + " block");
                        }
                        break block98;
                    }
                    if (customblock instanceof CustomBlockPortal) {
                        try {
                            bi = ImageIO.read(Util.instance.getModInputStream("ep.png"));
                        }
                        catch (Exception e) {
                            bi = new BufferedImage(256, 256, 6);
                        }
                        bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.0f, 0, 0, 0, 255), "png", texture);
                        texture = new File(texturesDir, fileName.toLowerCase() + "_portal.png");
                        if (!texture.exists()) {
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.0f, 0, 0, 0, 255), "png", texture) && bo;
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_sky.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("es.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(128, 128, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.0f, 0, 0, 0, 255), "png", texture) && bo;
                        }
                        if (bo) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" block portal");
                        }
                        break block98;
                    }
                    if (customblock instanceof CustomDoor) {
                        File texturesItemDir;
                        texture = new File(texturesDir, fileName.toLowerCase() + "_lower.png");
                        if (!texture.exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("dwl.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.15f, 0, 10, 0, 255), "png", texture);
                        }
                        if (!(texture = new File(texturesDir, fileName.toLowerCase() + "_upper.png")).exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("dwu.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.15f, 0, 10, 0, 255), "png", texture) && bo;
                        }
                        if (!(texturesItemDir = new File(CustomNpcs.Dir, "assets/customnpcs/textures/items")).exists() && !texturesItemDir.mkdirs()) {
                            return;
                        }
                        texture = new File(texturesItemDir, fileName.toLowerCase() + ".png");
                        if (!texture.exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("dw.png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(16, 16, 6);
                            }
                            boolean bl = bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.15f, 0, 10, 0, 255), "png", texture) && bo;
                        }
                        if (bo) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" block door");
                        }
                        break block98;
                    }
                    if (customblock instanceof CustomChest) {
                        boolean type = ((CustomChest)customblock).isChest;
                        if (!type) {
                            texture = new File(texturesDir, "custom_" + name + "_side.png");
                            if (!texture.exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("hs.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.35f, 0, 0, 15, 255), "png", texture);
                            }
                            if (!(texture = new File(texturesDir, "custom_" + name + "_top.png")).exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("ht.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(16, 16, 6);
                                }
                                bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.35f, 0, 0, 15, 255), "png", texture) && bo;
                            }
                        } else {
                            texturesDir = new File(CustomNpcs.Dir, "assets/customnpcs/textures/entity/chest");
                            if (!texturesDir.exists() && !texturesDir.mkdirs()) {
                                return;
                            }
                            texture = new File(texturesDir, "custom_" + name + ".png");
                            if (!texture.exists()) {
                                try {
                                    bi = ImageIO.read(Util.instance.getModInputStream("hc.png"));
                                }
                                catch (Exception e) {
                                    bi = new BufferedImage(64, 64, 6);
                                }
                                bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.35f, 25, 0, 0, 255), "png", texture);
                            }
                        }
                        if (bo) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" " + (type ? "chest" : "container") + " block");
                        }
                        break block98;
                    }
                    if (ImageIO.write(this.getBufferImageOffset(bi, 0, 0.65f, 25, 0, 0, 255), "png", texture)) {
                        LogWriter.debug("Create Default Texture for \"" + name + "\" block");
                    }
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            }
        }
    }

    @Override
    public void checkItemFiles(ICustomElement customitem) {
        BufferedImage bi;
        String parentName;
        File texture;
        File texturesDir;
        String textureName;
        String name;
        block74: {
            super.checkItemFiles(customitem);
            name = customitem.getCustomName().toLowerCase();
            String fileName = Objects.requireNonNull(((Item)customitem).getRegistryName()).func_110623_a();
            NBTTagCompound nbtData = customitem.getCustomNbt().getMCNBT();
            String n = name;
            switch (name) {
                case "itemexample": {
                    n = "Example simple Custom Item";
                    break;
                }
                case "weaponexample": {
                    n = "Example Custom Weapon";
                    break;
                }
                case "toolexample": {
                    n = "Example Custom Tool";
                    break;
                }
                case "axeexample": {
                    n = "Example Custom Axe";
                    break;
                }
                case "armorexample": {
                    String slot = ((CustomArmor)customitem).func_185083_B_().name();
                    n = "Example Custom Armor (" + ("" + slot.charAt(0)).toUpperCase() + slot.toLowerCase().substring(1) + ")";
                    break;
                }
                case "armorobjexample": {
                    if (((CustomArmor)customitem).func_185083_B_() == EntityEquipmentSlot.FEET) {
                        n = "Example Custom 3D Armor (Boots)";
                        break;
                    }
                    String slot = ((CustomArmor)customitem).func_185083_B_().name();
                    n = "Example Custom 3D Armor (" + ("" + slot.charAt(0)).toUpperCase() + slot.toLowerCase().substring(1) + ")";
                    break;
                }
                case "shieldexample": {
                    n = "Example Custom Shield";
                    break;
                }
                case "bowexample": {
                    n = "Example Custom Bow";
                    break;
                }
                case "foodexample": {
                    n = "Example Custom Food";
                    break;
                }
                case "fishingrodexample": {
                    n = "Example Custom Fishing Rod";
                }
            }
            while (n.indexOf(95) != -1) {
                n = n.replace('_', ' ');
            }
            this.setLocalization("item." + fileName + ".name", n);
            textureName = name;
            File itemModelsDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/item");
            if (!itemModelsDir.exists() && !itemModelsDir.mkdirs()) {
                return;
            }
            File itemModel = new File(itemModelsDir, fileName.toLowerCase() + ".json");
            String texturePath = "customnpcs/textures/items";
            if (itemModel.exists()) {
                try {
                    String line;
                    BufferedReader reader = Files.newBufferedReader(itemModel.toPath());
                    while ((line = reader.readLine()) != null) {
                        if (!line.contains("layer0")) continue;
                        String tempLine = line.substring(line.indexOf(34, line.indexOf(58)) + 1, line.lastIndexOf(34));
                        if (tempLine.indexOf(58) != -1) {
                            if (tempLine.indexOf(47) != -1) {
                                textureName = tempLine.substring(tempLine.lastIndexOf(47) + 1);
                                texturePath = "customnpcs/textures/" + tempLine.substring(tempLine.indexOf(58) + 1, tempLine.lastIndexOf(47));
                                break;
                            }
                            texturePath = "customnpcs/textures/";
                            textureName = tempLine.substring(tempLine.indexOf(58) + 1);
                            break;
                        }
                        textureName = tempLine;
                        texturePath = "customnpcs/textures";
                        break;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            }
            if (!(texturesDir = new File(CustomNpcs.Dir, "assets/" + texturePath)).exists() && !texturesDir.mkdirs()) {
                return;
            }
            texture = null;
            parentName = null;
            boolean bo = true;
            try {
                if (customitem instanceof CustomArmor) {
                    File armorDir = new File(CustomNpcs.Dir, "assets/customnpcs/textures/models/armor");
                    if (!armorDir.exists() && !armorDir.mkdirs()) {
                        return;
                    }
                    if (nbtData.func_150297_b("OBJData", 9) || nbtData.func_150297_b("OBJData", 10)) {
                        BufferedImage bi2;
                        texture = new File(armorDir, name + ".png");
                        if (texture.exists()) {
                            return;
                        }
                        try {
                            bi2 = ImageIO.read(Util.instance.getModInputStream("am_i.png"));
                        }
                        catch (Exception e) {
                            bi2 = new BufferedImage(64, 64, 6);
                        }
                        if (ImageIO.write((RenderedImage)bi2, "png", texture)) {
                            LogWriter.debug("Create Default Armor Model Texture for \"" + name + "\" item");
                        }
                        return;
                    }
                    for (int i = 1; i <= 2; ++i) {
                        texture = new File(armorDir, name + "_layer_" + i + ".png");
                        if (!texture.exists()) {
                            try {
                                bi = ImageIO.read(Util.instance.getModInputStream("ail" + i + ".png"));
                            }
                            catch (Exception e) {
                                bi = new BufferedImage(64, 32, 6);
                            }
                            bo = ImageIO.write(this.getBufferImageOffset(bi, 0, 0.1f, 0, 40, 40, 255), "png", texture) && bo;
                            continue;
                        }
                        bo = false;
                    }
                    if (bo) {
                        LogWriter.debug("Create Default Armor Model Texture for \"" + name + "\" item");
                    }
                    texture = new File(texturesDir, textureName + ".png");
                    switch (((CustomArmor)customitem).func_185083_B_()) {
                        case HEAD: {
                            parentName = "ah";
                            break;
                        }
                        case CHEST: {
                            parentName = "ac";
                            break;
                        }
                        case LEGS: {
                            parentName = "al";
                            break;
                        }
                        default: {
                            parentName = "ab";
                            break;
                        }
                    }
                    break block74;
                }
                if (customitem instanceof CustomTool && name.equals("axeexample")) {
                    texture = new File(texturesDir, name + ".png");
                    if (!texture.exists()) {
                        BufferedImage bi3;
                        try {
                            bi3 = ImageIO.read(Util.instance.getModInputStream("axe.png"));
                        }
                        catch (Exception e) {
                            bi3 = new BufferedImage(64, 32, 6);
                        }
                        if (ImageIO.write(this.getBufferImageOffset(bi3, 0, 0.0f, 0, 0, 0, 255), "png", texture)) {
                            LogWriter.debug("Create Default Texture for \"" + name + "\" item");
                        }
                    }
                    return;
                }
                if (customitem instanceof CustomBow) {
                    for (int i = 0; i < 4; ++i) {
                        BufferedImage bi4;
                        texture = new File(texturesDir, textureName.replace("_standby", "") + (i == 0 ? "_standby" : "_pulling_" + (i - 1)) + ".png");
                        if (texture.exists()) continue;
                        try {
                            bi4 = ImageIO.read(Util.instance.getModInputStream("b_" + i + ".png"));
                        }
                        catch (Exception e) {
                            bi4 = new BufferedImage(16, 16, 6);
                        }
                        bo = ImageIO.write(this.getBufferImageOffset(bi4, 0, 0.0f, 0, 40, 40, 255), "png", texture) && bo;
                    }
                    if (bo) {
                        LogWriter.debug("Create Default Bow Texture for \"" + name + "\" item");
                    }
                    return;
                }
                if (!(customitem instanceof CustomFishingRod)) break block74;
                n = textureName.replace("_uncast", "").replace("_cast", "");
                for (int i = 0; i < 2; ++i) {
                    BufferedImage bi5;
                    texture = new File(texturesDir, n + (i == 0 ? "_uncast" : "_cast") + ".png");
                    if (texture.exists()) continue;
                    try {
                        bi5 = ImageIO.read(Util.instance.getModInputStream("fr_" + i + ".png"));
                    }
                    catch (Exception e) {
                        bi5 = new BufferedImage(16, 16, 6);
                    }
                    bo = ImageIO.write(this.getBufferImageOffset(bi5, 0, 0.0f, 0, 40, 0, 255), "png", texture) && bo;
                }
                if (bo) {
                    LogWriter.debug("Create Default Fishing Rod Texture for \"" + name + "\" item");
                }
                return;
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        if (parentName == null) {
            texture = new File(texturesDir, textureName + ".png");
            parentName = customitem instanceof CustomWeapon ? "sw" : (customitem instanceof CustomTool ? "pa" : (customitem instanceof CustomShield ? "sh" : (customitem instanceof CustomFood ? "sc" : "si")));
        }
        if (!texture.exists()) {
            try {
                try {
                    bi = ImageIO.read(Util.instance.getModInputStream(parentName + ".png"));
                }
                catch (Exception e) {
                    bi = new BufferedImage(16, 16, 6);
                }
                if (ImageIO.write(this.getBufferImageOffset(bi, 0, 0.0f, 40, 0, 40, 255), "png", texture)) {
                    LogWriter.debug("Create Default Texture for \"" + name + "\" item");
                }
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
    }

    @Override
    public void checkParticleFiles(ICustomElement customparticle) {
        String name;
        super.checkParticleFiles(customparticle);
        String n = name = customparticle.getCustomName();
        if (name.equalsIgnoreCase("PARTICLE_EXAMPLE")) {
            n = "Example Custom Particle";
        } else if (name.equalsIgnoreCase("PARTICLE_OBJ_EXAMPLE")) {
            n = "Example Custom OBJ Particle";
        }
        while (n.indexOf(95) != -1) {
            n = n.replace('_', ' ');
        }
        this.setLocalization("particle." + name, n);
        INbt nbt = customparticle.getCustomNbt();
        if (nbt.getMCNBT().func_150297_b("OBJModel", 8)) {
            File mtlFile;
            File modelDir = new File(CustomNpcs.Dir, "assets/customnpcs/models/particle");
            if (!modelDir.exists() && !modelDir.mkdirs()) {
                return;
            }
            name = nbt.getString("OBJModel");
            File modelFile = new File(modelDir, name + ".obj");
            if (!modelFile.exists() && Util.instance.saveFile(modelFile, Util.instance.getDataFile("pe_o.dat").replace("{mod_id}", "customnpcs").replace("{name}", name))) {
                LogWriter.debug("Create Default OBJ Model for \"" + name + ".obj\" particle");
            }
            if (!(mtlFile = new File(modelDir, name + ".mtl")).exists() && Util.instance.saveFile(mtlFile, Util.instance.getDataFile("pe_m.dat").replace("{mod_id}", "customnpcs").replace("{name}", name))) {
                LogWriter.debug("Create Default OBJ Material Library for \"" + name + ".mtl\" particle");
            }
        } else {
            String textureName = nbt.getString("Texture");
            File texturesDir = new File(CustomNpcs.Dir, "assets/customnpcs/textures/particle");
            if (!texturesDir.exists() && !texturesDir.mkdirs()) {
                return;
            }
            File texture = new File(texturesDir, textureName + ".png");
            if (!texture.exists()) {
                boolean has = false;
                try {
                    IResource baseTexture = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("minecraft", "textures/particle/particles.png"));
                    BufferedImage particlesImage = new BufferedImage(128, 128, 6);
                    BufferedImage bufferedImage = ImageIO.read(baseTexture.func_110527_b());
                    for (int u = 0; u < 128; ++u) {
                        for (int v = 0; v < 128; ++v) {
                            Color c = new Color(bufferedImage.getRGB(u, v));
                            if (c.getRGB() == -16777216) continue;
                            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                            hsb[0] = hsb[0] + 0.25f;
                            if (hsb[0] > 1.0f) {
                                hsb[0] = hsb[0] - 1.0f;
                            }
                            c = Color.getHSBColor(hsb[0] - (hsb[0] > 1.0f ? 1.0f : 0.0f), hsb[1], hsb[2]);
                            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 171);
                            particlesImage.setRGB(u, v, c.getRGB());
                        }
                    }
                    ImageIO.write((RenderedImage)particlesImage, "png", texture);
                    has = true;
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                if (!has) {
                    try {
                        BufferedImage bufferedImage = new BufferedImage(128, 128, 6);
                        ImageIO.write((RenderedImage)bufferedImage, "png", texture);
                        has = true;
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                }
                if (has) {
                    LogWriter.debug("Create Default Texture for \"" + name + "\" particle");
                }
            }
        }
    }

    @Override
    public void checkPotionFiles(ICustomElement custompotion) {
        String name;
        super.checkPotionFiles(custompotion);
        String n = name = custompotion.getCustomName().toLowerCase();
        if (name.equals("potionexample")) {
            n = "Example Custom Potion";
        }
        while (n.indexOf(95) != -1) {
            n = n.replace('_', ' ');
        }
        this.setLocalization("effect." + name, n);
        this.setLocalization("potion.effect." + name, n);
        this.setLocalization("splash_potion.effect." + name, name.equals("potionexample") ? "Example Custom Splash Potion" : n + " Splash");
        this.setLocalization("lingering_potion.effect." + name, name.equals("potionexample") ? "Example Custom Lingering Potion" : n + " Lingering");
        this.setLocalization("tipped_arrow.effect." + name, name.equals("potionexample") ? "Example Custom Arrow Potion" : n + " Arrow");
        File texturesDir = new File(CustomNpcs.Dir, "assets/customnpcs/textures/potions");
        if (!texturesDir.exists() && !texturesDir.mkdirs()) {
            return;
        }
        File texture = new File(texturesDir, name + ".png");
        if (!texture.exists()) {
            boolean has = false;
            try {
                IResource baseTexture = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("minecraft", "textures/gui/container/inventory.png"));
                BufferedImage potionImage = new BufferedImage(18, 18, 6);
                BufferedImage bufferedImage = ImageIO.read(baseTexture.func_110527_b());
                for (int u = 0; u < 18; ++u) {
                    for (int v = 0; v < 18; ++v) {
                        Color c = new Color(bufferedImage.getRGB(u + 36, v + 235));
                        if (c.getRGB() == -16777216) continue;
                        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                        hsb[0] = hsb[0] + 0.25f;
                        if (hsb[0] > 1.0f) {
                            hsb[0] = hsb[0] - 1.0f;
                        }
                        c = Color.getHSBColor(hsb[0] - (hsb[0] > 1.0f ? 1.0f : 0.0f), hsb[1], hsb[2]);
                        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
                        potionImage.setRGB(u, v, c.getRGB());
                    }
                }
                ImageIO.write((RenderedImage)potionImage, "png", texture);
                LogWriter.debug("Create Default Texture for \"" + name + "\" potion");
                has = true;
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
            if (!has) {
                try {
                    BufferedImage bufferedImage = new BufferedImage(18, 18, 6);
                    ImageIO.write((RenderedImage)bufferedImage, "png", texture);
                    LogWriter.debug("Create Default Texture for \"" + name + "\" potion");
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            }
        }
    }

    @Override
    public void checkTexture(EntityNPCInterface npc) {
        if (npc.display.skinType != 0) {
            return;
        }
        ClientProxy.createPlayerSkin(new ResourceLocation(npc.display.getSkinTexture()));
    }

    private void createFolders() {
        File fonts;
        File textures;
        File json;
        File dir = new File(CustomNpcs.Dir, "assets/customnpcs");
        if (!dir.exists() && !dir.mkdirs()) {
            LogWriter.error("Failed to create directory " + dir.getAbsolutePath());
            return;
        }
        File sounds = new File(dir, "sounds");
        if (!sounds.exists() && !sounds.mkdirs()) {
            LogWriter.error("Failed to create directory " + sounds.getAbsolutePath());
        }
        if (!(json = new File(dir, "sounds.json")).exists()) {
            try {
                if (!json.createNewFile()) {
                    LogWriter.error("Failed to create file " + json.getAbsolutePath());
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(json));
                writer.write("{\n\n}");
                writer.close();
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        if (!(textures = new File(dir, "textures")).exists() && !textures.mkdirs()) {
            LogWriter.error("Failed to create directory " + textures.getAbsolutePath());
        }
        if (!(fonts = new File(dir, "fonts")).exists() && !fonts.mkdir()) {
            LogWriter.error("Failed to create directory " + fonts.getAbsolutePath());
        }
    }

    @Override
    public void fixTileEntityData(TileEntity tile) {
        NoppesUtilPlayer.sendData(EnumPlayerPacket.GetTileData, tile.func_189515_b(new NBTTagCompound()));
    }

    private RenderedImage getBufferImageOffset(@Nonnull BufferedImage bufferedImage, int type, float offset, int addRed, int addGreen, int addBlue, int alpha) {
        if (type < 0) {
            type = 0;
        } else if (type > 2) {
            type = 2;
        }
        try {
            for (int u = 0; u < bufferedImage.getWidth(); ++u) {
                for (int v = 0; v < bufferedImage.getHeight(); ++v) {
                    Color c = new Color(bufferedImage.getRGB(u, v));
                    if (c.getRGB() == -16777216) continue;
                    float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                    int n = type;
                    hsb[n] = hsb[n] + offset;
                    int n2 = type;
                    hsb[n2] = hsb[n2] % 1.0f;
                    c = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
                    c = new Color((c.getRed() + addRed) % 256, (c.getGreen() + addGreen) % 256, (c.getBlue() + addBlue) % 256, alpha);
                    bufferedImage.setRGB(u, v, c.getRGB());
                }
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        return bufferedImage;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID > EnumGuiType.values().length) {
            return null;
        }
        EnumGuiType gui = EnumGuiType.values()[ID];
        EntityNPCInterface npc = NoppesUtil.getLastNpc();
        Container container = this.getContainer(gui, player, x, y, z, npc);
        return this.getGui(npc, gui, container, x, y, z);
    }

    private GuiScreen getGui(EntityNPCInterface npc, EnumGuiType gui, Container container, int x, int y, int z) {
        ClientEvent.PreGetGuiCustomNpcs preEvent = new ClientEvent.PreGetGuiCustomNpcs(npc, gui, container, x, y, z);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        if (preEvent.isCanceled()) {
            return null;
        }
        if (preEvent.returnGui != null) {
            return preEvent.returnGui;
        }
        Object returnGui = null;
        switch (gui) {
            case AvailabilityStack: {
                returnGui = new SubGuiNpcAvailabilityItemStacks((ContainerAvailabilityInv)container);
                break;
            }
            case CustomContainer: {
                returnGui = new GuiCustomContainer((ContainerChestCustom)container);
                break;
            }
            case CustomChest: {
                returnGui = new GuiCustomChest((ContainerCustomChest)container);
                break;
            }
            case MainMenuDisplay: {
                if (npc != null) {
                    returnGui = new GuiNpcDisplay(npc);
                    break;
                }
                this.getPlayer().func_145747_a((ITextComponent)new TextComponentString(Util.instance.translateGoogle(this.getPlayer(), "Unable to find npc")));
                break;
            }
            case MainMenuStats: {
                returnGui = npc == null ? null : new GuiNpcStats(npc);
                break;
            }
            case MainMenuInv: {
                returnGui = new GuiNPCInv(npc, (ContainerNPCInv)container);
                break;
            }
            case MainMenuInvDrop: {
                returnGui = new GuiDropEdit(npc, (ContainerNPCDropSetup)container, (GuiContainer)Minecraft.func_71410_x().field_71462_r, x, y, z);
                break;
            }
            case MainMenuAdvanced: {
                returnGui = new GuiNpcAdvanced(npc);
                break;
            }
            case QuestReward: {
                returnGui = new GuiNpcQuestReward(npc, (ContainerNpcQuestReward)container);
                break;
            }
            case QuestTypeItem: {
                Quest quest = NoppesUtilServer.getEditingQuest(this.getPlayer());
                if ((quest == null || quest.questInterface.tasks[x].getEnumType() != EnumQuestTask.ITEM) && Objects.requireNonNull(quest).questInterface.tasks[x].getEnumType() != EnumQuestTask.CRAFT) break;
                returnGui = new GuiNpcQuestTypeItem(npc, (ContainerNpcQuestTypeItem)container, quest.questInterface.tasks[x]);
                break;
            }
            case QuestRewardItem: {
                returnGui = new GuiNpcQuestRewardItem((ContainerNpcQuestRewardItem)container, x);
                break;
            }
            case MovingPath: {
                returnGui = npc == null ? null : new GuiNpcPather(npc);
                break;
            }
            case ManageFactions: {
                returnGui = new GuiNPCManageFactions(npc);
                break;
            }
            case ManageLinked: {
                returnGui = new GuiNPCManageLinkedNpc(npc);
                break;
            }
            case ManageMail: {
                returnGui = new GuiNPCManageMail(npc);
                break;
            }
            case BuilderBlock: {
                returnGui = new GuiBlockBuilder(x, y, z);
                break;
            }
            case ManageTransport: {
                returnGui = new GuiNPCManageTransporters(npc, (ContainerNPCTransportSetup)container);
                break;
            }
            case ManageRecipes: {
                returnGui = new GuiNPCManageRecipes(npc, (ContainerManageRecipes)container);
                break;
            }
            case ManageDialogs: {
                returnGui = new GuiNPCManageDialogs(npc);
                break;
            }
            case ManageQuests: {
                returnGui = new GuiNPCManageQuest(npc);
                break;
            }
            case ManageBanks: {
                returnGui = new GuiNPCManageBanks(npc, (ContainerManageBanks)container);
                break;
            }
            case MainMenuGlobal: {
                returnGui = new GuiNPCGlobalMainMenu(npc);
                break;
            }
            case MainMenuAI: {
                returnGui = new GuiNpcAI(npc);
                break;
            }
            case PlayerAnvil: {
                returnGui = new GuiNpcCarpentryBench((ContainerCarpentryBench)container);
                break;
            }
            case PlayerFollowerHire: {
                returnGui = new GuiNpcFollowerHire(npc, (ContainerNPCFollowerHire)container);
                break;
            }
            case PlayerFollower: {
                returnGui = new GuiNpcFollower(npc, (ContainerNPCFollowerHire)container);
                break;
            }
            case PlayerTrader: {
                returnGui = new GuiNPCTrader(npc, (ContainerNPCTrader)container);
                break;
            }
            case PlayerBank: {
                returnGui = new GuiNPCBankChest(npc, (ContainerNPCBank)container);
                Minecraft mc = Minecraft.func_71410_x();
                if (!(mc.field_71462_r instanceof GuiNPCBankChest) || ((GuiNPCBankChest)mc.field_71462_r).cont.bank.id != ((ContainerNPCBank)container).bank.id || ((GuiNPCBankChest)mc.field_71462_r).cont.ceil != ((ContainerNPCBank)container).ceil) break;
                ((GuiNPCBankChest)returnGui).row = ((GuiNPCBankChest)mc.field_71462_r).row;
                break;
            }
            case PlayerTransporter: {
                returnGui = new GuiTransportSelection(npc);
                break;
            }
            case Script: {
                returnGui = new GuiScript(npc);
                break;
            }
            case ScriptBlock: {
                returnGui = new GuiScriptBlock(x, y, z);
                break;
            }
            case ScriptItem: {
                returnGui = new GuiScriptItem();
                break;
            }
            case ScriptDoor: {
                returnGui = new GuiScriptDoor(x, y, z);
                break;
            }
            case ScriptPlayers: {
                returnGui = new GuiScriptGlobal();
                break;
            }
            case SetupFollower: {
                returnGui = new GuiNpcFollowerSetup(npc, (ContainerNPCFollowerSetup)container);
                break;
            }
            case SetupItemGiver: {
                returnGui = new GuiNpcItemGiver(npc, (ContainerNpcItemGiver)container);
                break;
            }
            case SetupTrader: {
                if (x >= 0) {
                    GuiNPCManageMarkets.marcetId = x;
                }
                if (y >= 0) {
                    GuiNPCManageMarkets.dealId = y;
                }
                returnGui = new GuiNPCManageMarkets(npc);
                break;
            }
            case SetupTraderDeal: {
                returnGui = new SubGuiNPCManageDeal(npc, (ContainerNPCTraderSetup)container);
                break;
            }
            case SetupTransporter: {
                returnGui = new GuiNpcTransporter(npc);
                break;
            }
            case SetupBank: {
                returnGui = new GuiNpcBankSetup(npc);
                break;
            }
            case NpcRemote: {
                returnGui = Minecraft.func_71410_x().field_71462_r == null ? new GuiNpcRemoteEditor() : null;
                break;
            }
            case PlayerMailbox: {
                returnGui = new GuiMailbox();
                break;
            }
            case PlayerMailOpen: {
                returnGui = new GuiMailmanWrite((ContainerMail)container, x == 1, y == 1);
                break;
            }
            case MerchantAdd: {
                returnGui = new GuiMerchantAdd();
                break;
            }
            case NpcDimensions: {
                returnGui = new GuiNpcDimension();
                break;
            }
            case Border: {
                returnGui = new GuiBorderBlock(x, y, z);
                break;
            }
            case RedstoneBlock: {
                returnGui = new GuiNpcRedstoneBlock(x, y, z);
                break;
            }
            case MobSpawner: {
                returnGui = new GuiNpcMobSpawner(x, y, z);
                break;
            }
            case CopyBlock: {
                returnGui = new GuiBlockCopy(x, y, z);
                break;
            }
            case MobSpawnerMounter: {
                returnGui = new GuiNpcMobSpawnerMounter(x, y, z);
                break;
            }
            case Waypoint: {
                returnGui = new GuiNpcWaypoint(x, y, z);
                break;
            }
            case Companion: {
                returnGui = new GuiNpcCompanionStats(npc);
                break;
            }
            case CompanionTalent: {
                returnGui = new GuiNpcCompanionTalents(npc);
                break;
            }
            case CompanionInv: {
                returnGui = new GuiNpcCompanionInv(npc, (ContainerNPCCompanion)container);
                break;
            }
            case NbtBook: {
                returnGui = new GuiNbtBook(x, y, z);
                break;
            }
            case CustomGui: {
                returnGui = new GuiCustom((ContainerCustomGui)container);
                break;
            }
            case BoundarySetting: {
                returnGui = new GuiBoundarySetting(x, y);
                break;
            }
            case QuestLog: {
                returnGui = new GuiLog(x);
                break;
            }
            case BuilderSetting: 
            case ReplaceSetting: 
            case PlacerSetting: 
            case SaverSetting: 
            case RemoverSetting: {
                returnGui = new GuiBuilderSetting((ContainerBuilderSettings)container);
                break;
            }
            case DimensionSetting: {
                returnGui = new GuiCreateDimension(x);
                break;
            }
            case DeadInventory: {
                returnGui = new GuiNPCDeadInventory(npc, (ContainerDead)container);
                break;
            }
            case CreationParts: {
                returnGui = new GuiCreationParts(npc, (ContainerLayer)container);
                break;
            }
        }
        ClientEvent.PostGetGuiCustomNpcs postEvent = new ClientEvent.PostGetGuiCustomNpcs(npc, gui, container, x, y, z, (GuiScreen)returnGui);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        if (postEvent.isCanceled()) {
            return null;
        }
        return postEvent.returnGui;
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public PlayerData getPlayerData(EntityPlayer player) {
        if (playerData.getPlayer() != player) {
            playerData.setPlayer(player);
        }
        return playerData;
    }

    @Override
    public void load() {
        Minecraft mc = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        if (CustomNpcs.InventoryGuiEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
            if (TabRegistry.getTabList().isEmpty()) {
                TabRegistry.registerTab(new InventoryTabVanilla());
                TabRegistry.registerTab(new InventoryTabFactions());
                TabRegistry.registerTab(new InventoryTabQuests());
            }
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcPony.class, new RenderNPCPony());
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcCrystal.class, new RenderNpcCrystal(new ModelNpcCrystal()));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcDragon.class, new RenderNpcDragon(new ModelNpcDragon(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcSlime.class, new RenderNpcSlime(new ModelNpcSlime(16), new ModelNpcSlime(0), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectile.class, new RenderProjectile());
        RenderingRegistry.registerEntityRenderingHandler(EntityNPCGolem.class, new RenderNPCInterface((ModelBase)new ModelNPCGolem(0.0f), 0.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcClassicPlayer.class, new RenderCustomNpc((ModelBiped)new ModelNpcAlt(0.0f, false, true)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNPC64x32.class, new RenderCustomNpc((ModelBiped)new ModelBipedAlt(0.0f, false, false, false)));
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomNpc.class, new RenderCustomNpc((ModelBiped)new ModelNpcAlt(0.0f, false, false)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcAlex.class, new RenderCustomNpc((ModelBiped)new ModelNpcAlt(0.0f, true, false)));
        mc.getItemColors().func_186730_a((stack, tintIndex) -> 9127187, new Item[]{CustomRegisters.mount, CustomRegisters.cloner, CustomRegisters.moving, CustomRegisters.scripter, CustomRegisters.wand, CustomRegisters.teleporter});
        mc.getItemColors().func_186730_a((stack, tintIndex) -> {
            IItemStack item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
            if (stack.func_77973_b() == CustomRegisters.scripted_item) {
                return ((IItemScripted)item).getColor();
            }
            return -1;
        }, new Item[]{CustomRegisters.scripted_item});
        ClientProxy.checkLocalization();
        new GuiTextureSelection(null, "", "png", 0);
        Map<Integer, IParticleFactory> map = ((IParticleManagerMixin)mc.field_71452_i).npcs$getParticleTypes();
        for (int id : CustomRegisters.customparticles.keySet()) {
            if (map.containsKey(id)) continue;
            map.put(id, (particleID, worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, parameters) -> {
                CustomParticleSettings ps = CustomRegisters.customparticles.get(particleID);
                return new CustomParticle(ps == null ? new NBTTagCompound() : ps.nbtData, worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
            });
        }
    }

    @Override
    public void openGui(EntityNPCInterface npc, EnumGuiType gui) {
        this.openGui(npc, gui, 0, 0, 0);
    }

    @Override
    public void openGui(EntityNPCInterface npc, EnumGuiType gui, int x, int y, int z) {
        Minecraft mc = Minecraft.func_71410_x();
        Container container = this.getContainer(gui, (EntityPlayer)mc.field_71439_g, x, y, z, npc);
        GuiScreen guiscreen = this.getGui(npc, gui, container, x, y, z);
        if (guiscreen != null) {
            mc.func_147108_a(guiscreen);
        }
    }

    @Override
    public void openGui(EntityPlayer player, Object guiscreen) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!player.field_70170_p.field_72995_K || !(guiscreen instanceof GuiScreen)) {
            return;
        }
        ClientEvent.NextToGuiCustomNpcs event = new ClientEvent.NextToGuiCustomNpcs(NoppesUtil.getLastNpc(), mc.field_71462_r, (GuiScreen)guiscreen);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.returnGui == null || event.isCanceled()) {
            return;
        }
        mc.func_147108_a(event.returnGui);
        if (mc.field_71462_r == null) {
            mc.func_71381_h();
        }
    }

    @Override
    public void openGui(int i, int j, int k, EnumGuiType gui, EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != player) {
            return;
        }
        GuiScreen guiscreen = this.getGui(null, gui, null, i, j, k);
        if (guiscreen != null) {
            mc.func_147108_a(guiscreen);
        }
    }

    @Override
    public void postload() {
        Minecraft mc;
        RenderItem ri;
        Map<IRegistryDelegate<Item>, Int2ObjectMap<IBakedModel>> models;
        ArmourersWorkshopUtil.getInstance();
        TileEntityRendererDispatcher.field_147556_a.field_147559_m.put(TileEntityBanner.class, new TileEntityCustomBannerRenderer());
        TileEntityItemStackRendererReflection.setBanner(TileEntityItemStackRenderer.field_147719_a, new TileEntityBanner());
        Item shield = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("shield"));
        if (shield instanceof ItemShield) {
            shield.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new TileEntityItemStackCustomRenderer());
        }
        if ((models = ItemModelMesherForgeReflection.getModels((ri = (mc = Minecraft.func_71410_x()).func_175599_af()).func_175037_a())) != null) {
            for (IRegistryDelegate<Item> key : models.keySet()) {
                IBakedModel ibm;
                if (!(key.get() instanceof CustomArmor) || ((CustomArmor)key.get()).objModel == null || (ibm = ModelBuffer.getIBakedModel((CustomArmor)key.get())) == null) continue;
                models.get(key).put(0, (Object)ibm);
            }
        }
        mcWrapper = new WrapperMinecraft(mc);
        ClientProxy.checkLocalization();
    }

    @Override
    public void preload() {
        Font = new FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
        this.createFolders();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new CustomNpcResourceListener());
        CustomNpcs.Channel.register((Object)new PacketHandlerClient());
        CustomNpcs.ChannelPlayer.register((Object)new PacketHandlerPlayer());
        new MusicController();
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientGuiEventHandler());
        ClientRegistry.registerKeyBinding((KeyBinding)QuestLog);
        for (IKeySetting ks : KeyController.getInstance().getKeySettings()) {
            KeyModifier modifer;
            switch (ks.getModiferType()) {
                case 1: {
                    modifer = KeyModifier.SHIFT;
                    break;
                }
                case 2: {
                    modifer = KeyModifier.CONTROL;
                    break;
                }
                case 3: {
                    modifer = KeyModifier.ALT;
                    break;
                }
                default: {
                    modifer = KeyModifier.NONE;
                }
            }
            ClientRegistry.registerKeyBinding((KeyBinding)new KeyBinding(ks.getName(), (IKeyConflictContext)KeyConflictContext.IN_GAME, modifer, ks.getKeyId(), ks.getCategory()));
        }
        new PresetController(CustomNpcs.Dir);
        if (CustomNpcs.EnableUpdateChecker) {
            VersionChecker checker = new VersionChecker();
            checker.start();
        }
        PixelmonHelper.loadClient();
        OBJLoader.INSTANCE.addDomain("customnpcs");
    }

    @Override
    public void reloadItemTextures() {
        for (Map.Entry<Integer, String> entry : ItemScripted.Resources.entrySet()) {
            ModelResourceLocation mrl = new ModelResourceLocation(entry.getValue(), "inventory");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)CustomRegisters.scripted_item, entry.getKey().intValue(), mrl);
            ModelLoader.setCustomModelResourceLocation((Item)CustomRegisters.scripted_item, (int)entry.getKey(), (ModelResourceLocation)mrl);
        }
    }

    private void setLocalization(String key, String value) {
        File langDir = new File(CustomNpcs.Dir, "assets/customnpcs/lang");
        if (!langDir.exists() && !langDir.mkdirs()) {
            return;
        }
        boolean isExample = key.contains("example") && value.contains("Example");
        boolean isTranslate = false;
        String currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        String translateValue = value;
        if (!currentLanguage.equals("en_us")) {
            String language = currentLanguage;
            if (currentLanguage.contains("_")) {
                language = currentLanguage.equals("zh_cn") ? "zh_CN" : (currentLanguage.equals("zh_tw") ? "zh_TW" : currentLanguage.substring(0, currentLanguage.indexOf("_")));
            }
            if (isExample) {
                translateValue = Util.instance.translateGoogle("en", language, value);
                if (translateValue.equals(value)) {
                    return;
                }
                isTranslate = true;
            } else {
                value = Util.instance.translateGoogle(language, "en", translateValue);
            }
        }
        boolean write = false;
        for (int i = 0; !(i >= 2 || i == 1 && currentLanguage.equals("en_us")); ++i) {
            File lang = new File(langDir, (i == 0 ? "en_us" : currentLanguage) + ".lang");
            TreeMap<String, String> jsonMap = new TreeMap<String, String>();
            jsonMap.put(key, i == 0 ? value : translateValue);
            char chr = Character.toChars(10)[0];
            BufferedWriter writer = null;
            if (!lang.exists()) {
                try {
                    writer = Files.newBufferedWriter(lang.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            } else {
                try {
                    String line;
                    BufferedReader reader = Files.newBufferedReader(lang.toPath());
                    while ((line = reader.readLine()) != null) {
                        if (!line.contains("=")) continue;
                        String[] vk = line.split("=");
                        if (vk[0].equals(key)) {
                            if (!isExample || isTranslate) continue;
                            jsonMap.put(vk[0], vk[1]);
                            continue;
                        }
                        jsonMap.put(vk[0], vk[1]);
                    }
                    reader.close();
                    writer = Files.newBufferedWriter(lang.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            }
            if (writer == null || jsonMap.isEmpty()) continue;
            try {
                StringBuilder jsonStr = new StringBuilder();
                String str = "";
                for (String k : jsonMap.keySet()) {
                    String pre;
                    String string = pre = k.contains(".") ? k.substring(0, k.indexOf(".")) : k;
                    if (!str.isEmpty() && !str.equals(pre)) {
                        jsonStr.append(chr);
                    }
                    str = pre;
                    jsonStr.append(k).append("=").append((String)jsonMap.get(k)).append(chr);
                }
                writer.write(jsonStr.toString());
                writer.close();
                write = true;
                continue;
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        if (write) {
            LogWriter.debug("Create Default Localization key \"" + key + "\"");
        }
    }

    @Override
    public void spawnParticle(EntityLivingBase player, String string, Object ... ob) {
        if (string.equals("Block")) {
            BlockPos pos = (BlockPos)ob[0];
            int id = (Integer)ob[1];
            Block block = Block.func_149729_e((int)(id & 0xFFF));
            Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, block.func_176203_a(id >> 12 & 0xFF));
        } else if (string.equals("ModelData")) {
            ModelData data = (ModelData)ob[0];
            ModelPartData particles = (ModelPartData)ob[1];
            EntityCustomNpc npc = (EntityCustomNpc)player;
            Minecraft minecraft = Minecraft.func_71410_x();
            double height = npc.func_70033_W() + (double)data.getBodyY();
            Random rand = npc.func_70681_au();
            for (int i = 0; i < 2; ++i) {
                EntityEnderFX fx = new EntityEnderFX(npc, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, rand.nextDouble() * (double)player.field_70131_O - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                minecraft.field_71452_i.func_78873_a((Particle)fx);
            }
        }
    }

    @Override
    public void spawnParticle(EnumParticleTypes particle, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null) {
            return;
        }
        double xx = entity.field_70165_t - x;
        double yy = entity.field_70163_u - y;
        double zz = entity.field_70161_v - z;
        if (xx * xx + yy * yy + zz * zz > 256.0) {
            return;
        }
        Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(particle.func_179348_c(), x, y, z, motionX, motionY, motionZ, new int[0]);
        if (fx == null) {
            return;
        }
        if (particle == EnumParticleTypes.FLAME) {
            ((IParticleFlameMixin)fx).npcs$setFlameScale(scale);
        } else if (particle == EnumParticleTypes.SMOKE_NORMAL) {
            ((IParticleSmokeNormalMixin)fx).npcs$setSmokeParticleScale(scale);
        }
    }

    @Override
    public void updateGUI() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return;
        }
        gui.func_73866_w_();
    }

    @Override
    public void updateKeys() {
        ArrayList<KeyBinding> list = new ArrayList<KeyBinding>();
        for (KeyBinding kb : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (keyBindingMap.containsValue(kb)) continue;
            list.add(kb);
        }
        HashMap<Integer, KeyBinding> keysMap = new HashMap<Integer, KeyBinding>();
        for (IKeySetting ks : KeyController.getInstance().getKeySettings()) {
            KeyBinding kb;
            KeyModifier modifer;
            switch (ks.getModiferType()) {
                case 1: {
                    modifer = KeyModifier.SHIFT;
                    break;
                }
                case 2: {
                    modifer = KeyModifier.CONTROL;
                    break;
                }
                case 3: {
                    modifer = KeyModifier.ALT;
                    break;
                }
                default: {
                    modifer = KeyModifier.NONE;
                }
            }
            boolean added = true;
            for (KeyBinding kbD : list) {
                if (kbD.getKeyModifier() != modifer || !kbD.func_151464_g().equals(ks.getName()) || kbD.func_151469_h() != ks.getKeyId() || !kbD.func_151466_e().equals(ks.getCategory())) continue;
                added = false;
                break;
            }
            if (!added) continue;
            if (keyBindingMap.containsKey(ks.getId())) {
                kb = keyBindingMap.get(ks.getId());
                KeyBindingReflection.setModifier(kb, modifer);
                KeyBindingReflection.setKeyDescription(kb, ks.getName());
                KeyBindingReflection.setKeyCodeDefault(kb, ks.getKeyId());
                KeyBindingReflection.setKeyCategory(kb, ks.getCategory());
            } else {
                kb = new KeyBinding(ks.getName(), (IKeyConflictContext)KeyConflictContext.IN_GAME, modifer, ks.getKeyId(), ks.getCategory());
            }
            list.add(kb);
            keysMap.put(ks.getId(), kb);
        }
        keyBindingMap.clear();
        keyBindingMap.putAll(keysMap);
        Minecraft.func_71410_x().field_71474_y.field_74324_K = list.toArray(new KeyBinding[0]);
    }

    @Override
    public void applyRecipe(INpcRecipe recipe, boolean added) {
        CreativeTabNpcs tab;
        if (recipe == null) {
            return;
        }
        super.applyRecipe(recipe, added);
        RecipeBook book = Minecraft.func_71410_x().field_71439_g != null ? Minecraft.func_71410_x().field_71439_g.func_192035_E() : null;
        CreativeTabNpcs creativeTabNpcs = tab = recipe.isGlobal() ? CustomRegisters.tab : CustomRegisters.tabItems;
        if (!RecipeBookClient.field_194086_e.containsKey((Object)tab)) {
            RecipeList recipelist = new RecipeList();
            RecipeBookClient.field_194087_f.add(recipelist);
            RecipeBookClient.field_194086_e.computeIfAbsent(tab, hasRecipeList -> new ArrayList()).add(recipelist);
            RecipeBookClient.field_194086_e.computeIfAbsent(CreativeTabs.field_78027_g, hasRecipeList -> new ArrayList()).add(recipelist);
        }
        RecipeList recipeList = null;
        boolean isWork = false;
        for (RecipeList rl : (List)RecipeBookClient.field_194086_e.get((Object)tab)) {
            if (!((IRecipeListMixin)rl).npcs$getGroup().equals(recipe.getNpcGroup())) continue;
            isWork = ((IRecipeListMixin)rl).npcs$applyRecipe(recipe, added);
            recipeList = rl;
            break;
        }
        if (!isWork) {
            if (added) {
                RecipeList newRecipeList = new RecipeList();
                newRecipeList.func_192709_a((IRecipe)recipe);
                ((List)RecipeBookClient.field_194086_e.get((Object)tab)).add(newRecipeList);
                RecipeBookClient.field_194087_f.add(newRecipeList);
                if (book != null) {
                    newRecipeList.func_194214_a(book);
                }
            }
        } else if (!added && recipeList.func_192711_b().isEmpty()) {
            ((List)RecipeBookClient.field_194086_e.get((Object)tab)).remove(recipeList);
            RecipeBookClient.field_194087_f.remove(recipeList);
        }
        if (book != null && (!added || recipe.isKnown())) {
            if (!added) {
                book.func_193831_b((IRecipe)recipe);
            } else {
                book.func_194073_a((IRecipe)recipe);
            }
            RecipeBookClient.field_194087_f.forEach(recipes -> recipes.func_194214_a(book));
        }
    }

    @Override
    public String getTranslateLanguage(EntityPlayer player) {
        String lang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        if (lang.contains("_")) {
            lang = lang.substring(0, lang.indexOf("_"));
        }
        return lang;
    }

    @Override
    public void loadAnimationModel(AnimationConfig animation) {
        ModelNpcAlt.loadAnimationModel(animation);
    }

    @Override
    public void updatePlayerPos() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.field_71174_a.func_147297_a((Packet)new CPacketPlayer.PositionRotation(player.field_70165_t, player.func_174813_aQ().field_72338_b, player.field_70161_v, player.field_70177_z, player.field_70125_A, player.field_70122_E));
        }
    }

    static {
        playerData = new PlayerData();
        loadFiles = new TreeMap<String, TempFile>();
        notVisibleNPC = new HashMap<Integer, List<UUID>>();
        texturesData = new HashMap<String, Map<String, TreeMap<ResourceLocation, Long>>>();
        keyBindingMap = new HashMap<Integer, KeyBinding>();
        notLoadTextures = new ArrayList<ResourceLocation>();
        mcWrapper = null;
    }

    public static class FontContainer {
        private TrueTypeFont textFont;
        public boolean useCustomFont = true;

        private FontContainer() {
        }

        public FontContainer(String fontType, int fontSize) {
            this.textFont = new TrueTypeFont(new Font(fontType, 0, fontSize), 1.0f);
            this.useCustomFont = !fontType.equalsIgnoreCase("minecraft");
            try {
                if (!this.useCustomFont || fontType.isEmpty() || fontType.equalsIgnoreCase("default")) {
                    this.textFont = new TrueTypeFont(new ResourceLocation("customnpcs", "fonts/jetbrainsmono.ttf"), fontSize, 1.0f);
                }
            }
            catch (Exception e) {
                LogWriter.info("Failed loading font so using Arial");
            }
        }

        public void clear() {
            if (this.textFont != null) {
                this.textFont.dispose();
            }
        }

        public FontContainer copy() {
            FontContainer font = new FontContainer();
            font.textFont = this.textFont;
            font.useCustomFont = this.useCustomFont;
            return font;
        }

        public void drawString(String text, int x, int y, int color) {
            if (this.useCustomFont && this.textFont.hasFont()) {
                this.textFont.draw(text, x, y, color);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)x, (float)y, color);
            }
        }

        public String getName() {
            if (!this.useCustomFont) {
                return "Minecraft";
            }
            return this.textFont.getFontName();
        }

        public int height(String text) {
            if (this.useCustomFont) {
                return this.textFont.height(text);
            }
            return Minecraft.func_71410_x().field_71466_p.field_78288_b;
        }

        public int width(String text) {
            if (this.useCustomFont) {
                return this.textFont.width(text);
            }
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        }
    }
}

